Ext.data.JsonP.sol_common_ObjectFormatter_MapTableToArray({"tagname":"class","name":"sol.common.ObjectFormatter.MapTableToArray","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true},"files":[{"filename":"lib_sol.common.ObjectFormatter.MapTableToArray.js","href":"lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray"}],"requires":["sol.common.ObjectUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":["sol.common.mixins.ObjectFilter"],"uses":[],"members":[{"name":"kind","tagname":"cfg","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"cfg-kind","meta":{}},{"name":"options","tagname":"cfg","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"cfg-options","meta":{}},{"name":"requiredConfig","tagname":"cfg","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"convertToArray","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-convertToArray","meta":{"private":true}},{"name":"format","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-format","meta":{}},{"name":"getFieldName","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-getFieldName","meta":{"private":true}},{"name":"getFieldNameIndex","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-getFieldNameIndex","meta":{}},{"name":"getIndexPosition","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-getIndexPosition","meta":{"private":true}},{"name":"getTargetFieldName","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-getTargetFieldName","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"returnOnlyPropSelector","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-returnOnlyPropSelector","meta":{"private":true}},{"name":"sanitizeOutputConfig","tagname":"method","owner":"sol.common.ObjectFormatter.MapTableToArray","id":"method-sanitizeOutputConfig","meta":{"private":true}}],"code_type":"ext_define","id":"class-sol.common.ObjectFormatter.MapTableToArray","short_doc":"Converts a MapTable of a TemplateSord structure into an array\nAll types except the mapKeys are ignored by the converter. ...","classIcon":"icon-class","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.ObjectFormatter.MapTableToArray</strong></div></div><h4>Mixins</h4><div class='dependency'>sol.common.mixins.ObjectFilter</div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.ObjectUtils' rel='sol.common.ObjectUtils' class='docClass'>sol.common.ObjectUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray' target='_blank'>lib_sol.common.ObjectFormatter.MapTableToArray.js</a></div></pre><div class='doc-contents'><p>Converts a MapTable of a TemplateSord structure into an array\nAll types except the mapKeys are ignored by the converter.</p>\n\n<p>MapTable fields that are not in the output definition\nare also not considered in the result and are discarded.</p>\n\n<p>This also works with wfMapKeys!</p>\n\n<p>Example of a TemplateSord object with MapTable</p>\n\n<p>   {\n      mapKeys: {\n         \"PERSON_ADDRESS_STREET1\": \"Musterstraße\",\n         \"PERSON_ADDRESS_CITY1\": \"Musterstadt\"\n      }\n   }</p>\n\n<p>Example Call</p>\n\n<pre><code>var converter = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.meeting.ObjectFormatter.MapTableToArrayToArray\", {\n  output: [\n    { source: { key: \"PERSON_CRUD_STATUS\" }, target: { prop: \"status\" } }\n    { source: { key: \"PERSON_ADDRESS_CITY\" },  target: { prop: \"city\" } }\n  ],\n  options: {\n    ignorePropertyNames: true,\n    filter: [\n     { \"prop\" : \"sord.mapKeys.SOLUTION_FIELD\", value: \"CREATE\" }\n   ]\n  }\n});\n</code></pre>\n\n<p>Output</p>\n\n<p>   [\n     { street: \"Musterstraße\", city: \"Musterstadt\", $mapIndex: \"1\"}\n   ]</p>\n\n<p>The special prop $mapIndex is added to the result object to determine the mapIndex in\nfurther processing</p>\n\n<h3>Options</h3>\n\n<p>   {\n      options: { ignorePropertyNames: true }\n   }</p>\n\n<p>When this parameter is defined, the target.prop name is ignored by default. An Array with objects on the original fieldnames will be created.</p>\n\n<h4>propSelector</h4>\n\n<p>When this parameter is defined the result array will be returned as simple string array instead of complex object\npropSelector must select an output target prop. Only this prop will be returned. Others will be ignored.</p>\n\n<pre><code> var converter = <a href=\"#!/api/sol-static-method-create\" rel=\"sol-static-method-create\" class=\"docClass\">sol.create</a>(\"sol.meeting.ObjectFormatter.MapTableToArray\", {\n  output: [\n    { source: { key: \"PERSON_USERNAME1\" }, target: { prop: \"username\" } }\n    { source: { key: \"PERSON_USERNAME2\" },  target: { prop: \"username\" } }\n  ],\n  options: {\n    propSelector: \"username\"\n  }\n});\n</code></pre>\n\n<p> Output</p>\n\n<p>   [\n     \"Sandra Renz\", \"Bodo Kraft\"\n   ]</p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-kind' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-cfg-kind' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-cfg-kind' class='name expandable'>kind</a> : String<span class=\"signature\"></span></div><div class='description'><div class='short'>(optional)\nUse formatter for wfMapKeys or mapKeys. ...</div><div class='long'><p>(optional)\nUse formatter for wfMapKeys or mapKeys. Only this types are supported.\nYou have to decide wheather you want to convert wfMapKeys or mapKeys</p>\n<p>Defaults to: <code>mapKeys</code></p></div></div></div><div id='cfg-options' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-cfg-options' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-cfg-options' class='name expandable'>options</a> : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<ul><li><span class='pre'>ignorePropertyNames</span> : Boolean<div class='sub-desc'><p>all target prop definition will be ignored</p>\n</div></li><li><span class='pre'>propSelector</span> : String|Boolean<div class='sub-desc'><p>return single property in a flat string array with the passed prop</p>\n</div></li></ul></div></div></div><div id='cfg-requiredConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n<p>Defaults to: <code>[&quot;output&quot;]</code></p><p>Overrides: <a href=\"#!/api/sol.Base-cfg-requiredConfig\" rel=\"sol.Base-cfg-requiredConfig\" class=\"docClass\">sol.Base.requiredConfig</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n<p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-property-logger\" rel=\"sol.common.ix.FunctionBase-property-logger\" class=\"docClass\">sol.common.ix.FunctionBase.logger</a>, <a href=\"#!/api/sol.common.ix.ServiceBase-property-logger\" rel=\"sol.common.ix.ServiceBase-property-logger\" class=\"docClass\">sol.common.ix.ServiceBase.logger</a></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-convertToArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-convertToArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-convertToArray' class='name expandable'>convertToArray</a>( <span class='pre'>result</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>result</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-format' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-format' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-format' class='name expandable'>format</a>( <span class='pre'>templateSord, config</span> )<span class=\"signature\"></span></div><div class='description'><div class='short'>Convert mapKeys of a templateSord object to an array ...</div><div class='long'><p>Convert mapKeys of a templateSord object to an array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>templateSord</span> : Object<div class='sub-desc'>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'>\n<ul><li><span class='pre'>fields</span> : Array<div class='sub-desc'>\n</div></li></ul></div></li></ul></div></div></div><div id='method-getFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-getFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-getFieldName' class='name expandable'>getFieldName</a>( <span class='pre'>fieldName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getFieldNameIndex' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-getFieldNameIndex' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-getFieldNameIndex' class='name expandable'>getFieldNameIndex</a>( <span class='pre'>fieldName</span> ) : Object<span class=\"signature\"></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : Object<div class='sub-desc'></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>mapIndex when field has any index otherwise -1</p>\n</div></li></ul></div></div></div><div id='method-getIndexPosition' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-getIndexPosition' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-getIndexPosition' class='name expandable'>getIndexPosition</a>( <span class='pre'>fieldName</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>fieldName</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-getTargetFieldName' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-getTargetFieldName' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-getTargetFieldName' class='name expandable'>getTargetFieldName</a>( <span class='pre'>mapKey, outputDefinition</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>mapKey</span> : Object<div class='sub-desc'></div></li><li><span class='pre'>outputDefinition</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n\n</div></li></ul><p>Overrides: <a href=\"#!/api/sol.common.ix.FunctionBase-method-initialize\" rel=\"sol.common.ix.FunctionBase-method-initialize\" class=\"docClass\">sol.common.ix.FunctionBase.initialize</a></p></div></div></div><div id='method-returnOnlyPropSelector' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-returnOnlyPropSelector' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-returnOnlyPropSelector' class='name expandable'>returnOnlyPropSelector</a>( <span class='pre'>arr</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>arr</span> : Object<div class='sub-desc'></div></li></ul></div></div></div><div id='method-sanitizeOutputConfig' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.ObjectFormatter.MapTableToArray'>sol.common.ObjectFormatter.MapTableToArray</span><br/><a href='source/lib_sol.common.ObjectFormatter.MapTableToArray.html#sol-common-ObjectFormatter-MapTableToArray-method-sanitizeOutputConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.ObjectFormatter.MapTableToArray-method-sanitizeOutputConfig' class='name expandable'>sanitizeOutputConfig</a>( <span class='pre'>output</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>output</span> : Object<div class='sub-desc'></div></li></ul></div></div></div></div></div></div></div>","meta":{}});